IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_REQ_TRANSF_LIB_CONFERENCIA]')
												 AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[P_EST_PROD_REQ_TRANSF_LIB_CONFERENCIA]
GO
GO  
--EXEC P_EST_PROD_REQ_TRANSF_LIB_CONFERENCIA
CREATE PROCEDURE P_EST_PROD_REQ_TRANSF_LIB_CONFERENCIA @QTDIAS INT =30 AS
SET NOCOUNT ON 
CREATE TABLE #RsTransfReqImp (CD_EMP INT, CD_FILIAL INT, CD_FILIAL_DEST INT,CD_PROD INT,QT_PROD MONEY,VLR_CUSTO MONEY,CD_IMP INT, CD_REQ INT)
CREATE TABLE #RsTransfReq (CD_EMP INT, CD_FILIAL INT, CD_FILIAL_ORIG INT, CD_IMP INT, CD_REQ INT, DT_ENT DATETIME, CD_USU INT)

INSERT INTO #RsTransfReq(CD_EMP, 
						CD_FILIAL, 
						CD_FILIAL_ORIG, 
						CD_IMP, 
						CD_REQ, 
						DT_ENT, 
						CD_USU)
SELECT      
	DISTINCT EST_PROD_IMP.CD_EMP,
	EST_PROD_IMP.CD_FILIAL,
	EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_FILIAL_ORIG,
	EST_PROD_IMP.CD_IMP,
	EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_REQ,
	EST_PROD_IMP.DT_CAD,
	EST_PROD_IMP.CD_USU
FROM      
	EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP INNER JOIN EST_PROD_IMP ON      
	EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_EMP = EST_PROD_IMP.CD_EMP AND     
	EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_FILIAL_DEST = EST_PROD_IMP.CD_FILIAL AND     
	EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_IMP = EST_PROD_IMP.CD_IMP AND
	EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_PROD = EST_PROD_IMP.CD_PROD 
WHERE
	EST_PROD_IMP.DT_CAD >= convert(date,getdate()-@QTDIAS)


INSERT INTO #RsTransfReqImp (CD_EMP, 
						 CD_FILIAL, 
						 CD_FILIAL_DEST,
						 CD_PROD,
						 QT_PROD,
						 VLR_CUSTO,
						 CD_IMP, 
						 CD_REQ)
Select 
	EST_PROD_REQ_TRANSF_LIB.CD_EMP,
	EST_PROD_REQ_TRANSF_LIB.CD_FILIAL,
	EST_PROD_REQ_TRANSF_LIB.CD_FILIAL_DEST, 
	EST_PROD_REQ_TRANSF_LIB_ITENS.CD_PROD,  
	EST_PROD_REQ_TRANSF_LIB_ITENS.QT_PROD, 
	EST_PROD_REQ_TRANSF_LIB_ITENS.VLR_CUSTO,
	ISNULL((SELECT      
				TOP 1 EST_PROD_IMP.CD_IMP   
			FROM      
				EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP INNER JOIN EST_PROD_IMP ON      
				EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_EMP = EST_PROD_IMP.CD_EMP AND     
				EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_FILIAL_DEST = EST_PROD_IMP.CD_FILIAL AND     
				EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_IMP = EST_PROD_IMP.CD_IMP AND
				EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_PROD = EST_PROD_IMP.CD_PROD 
WHERE      
	EST_PROD_REQ_TRANSF_LIB_ITENS.CD_EMP = EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_EMP AND     
	EST_PROD_REQ_TRANSF_LIB_ITENS.CD_FILIAL = EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_FILIAL_ORIG AND     
	EST_PROD_REQ_TRANSF_LIB_ITENS.CD_REQ = EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_REQ AND
	EST_PROD_REQ_TRANSF_LIB_ITENS.CD_PROD = EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_PROD),0) AS CD_ENTRADA,
	EST_PROD_REQ_TRANSF_LIB.CD_REQ	 
From  
	EST_PROD_REQ_TRANSF_LIB INNER JOIN EST_PROD_REQ_TRANSF_LIB_ITENS ON      
	EST_PROD_REQ_TRANSF_LIB.CD_EMP = EST_PROD_REQ_TRANSF_LIB_ITENS.CD_EMP AND     
	EST_PROD_REQ_TRANSF_LIB.CD_FILIAL = EST_PROD_REQ_TRANSF_LIB_ITENS.CD_FILIAL AND     
	EST_PROD_REQ_TRANSF_LIB.CD_REQ = EST_PROD_REQ_TRANSF_LIB_ITENS.CD_REQ  
	INNER JOIN #RsTransfReq P on
	EST_PROD_REQ_TRANSF_LIB.CD_EMP = p.CD_EMP AND     
	EST_PROD_REQ_TRANSF_LIB.CD_FILIAL = p.CD_FILIAL_ORIG AND     
	EST_PROD_REQ_TRANSF_LIB.CD_REQ = p.CD_REQ  

DELETE
	#RsTransfReqImp
WHERE
	CD_IMP > 0;

INSERT INTO EST_PROD_IMP (CD_EMP,CD_FILIAL,CD_IMP,CD_PROD,QT_ANT,QT_IMP,CD_USU,DT_CAD,HIST,TP_IMP,TP_EST,VLR_CUSTO_MD,DT_CAD_INFO,HR_CAD)	
SELECT
	t.CD_EMP,
	t.CD_FILIAL,
	t.CD_IMP,
	r.CD_PROD,
	0,
	r.QT_PROD,
	t.CD_USU,
	t.DT_ENT,
	'ENTRADA POR REQUISICAO REVISAO',
	5,
	0,
	r.VLR_CUSTO,
	GETDATE(),
	GETDATE()
FROM
	#RsTransfReqImp r inner join #RsTransfReq t ON
	r.CD_EMP = t.CD_EMP AND
	r.CD_FILIAL = t.CD_FILIAL_ORIG AND
	r.CD_REQ = t.CD_REQ

INSERT INTO EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP	(CD_EMP,CD_FILIAL_ORIG,CD_REQ,CD_PROD,CD_IMP,CD_FILIAL_DEST,QT_IT_CHECK)
SELECT
	t.CD_EMP,
	t.CD_FILIAL_ORIG,
	t.CD_REQ,
	r.CD_PROD,
	t.CD_IMP,
	t.CD_FILIAL,
	r.QT_PROD
FROM
	#RsTransfReqImp r inner join #RsTransfReq t ON
	r.CD_EMP = t.CD_EMP AND
	r.CD_FILIAL = t.CD_FILIAL_ORIG AND
	r.CD_REQ = t.CD_REQ

update
	c
set 
	c.QT_EST=(c.QT_EST + R.QT_PROD)
FROM
	#RsTransfReqImp r inner join est_prod_cpl c on
	r.cd_emp = c.cd_emp and
	r.cd_filial_dest = c.cd_filial and
	r.cd_prod = c.cd_prod 

DROP TABLE #RsTransfReqImp;
DROP TABLE #RsTransfReq;
